<?php
include 'koneksi.php';
include 'header1.php'; 

// Ambil ID dari URL
$id = $_GET["id"];

// Jika data dihapus
if (isset($_POST["hapus"])) {
    $query = "DELETE FROM mahasiswa WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "
        <script>
            alert('Data berhasil dihapus!');
            window.location= 'mahasiswa.php';
        </script>";
    } else {
        echo "
        <script>
            alert('Gagal menghapus data!');
        </script>";
    }
}

// Ambil data mahasiswa berdasarkan ID
$query = "SELECT * FROM mahasiswa WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$mhs = $result->fetch_assoc();

// Cek apakah tombol submit ditekan (update data)
if (isset($_POST["submit"])) {
    $alternatif = $_POST["alternatif"];
    $nama = $_POST["nama"];
    $nim = $_POST["nim"];
    $email = $_POST["email"];

    // Update data
    $query = "UPDATE mahasiswa SET alternatif = ?, nama = ?, nim = ?, email = ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssssi", $alternatif, $nama, $nim, $email, $id);

    if ($stmt->execute()) {
        echo "
        <script>
            alert('Data berhasil diubah!');
            window.location= 'mahasiswa.php';
        </script>";
    } else {
        echo "
        <script>
            alert('Data gagal diubah!');
        </script>";
    }
}
?>
<!-- ... (PHP bagian atas tetap sama) -->

<div id="layoutSidenav_content">
    <main>
    <div class="container-fluid mt-4">
        <h3 class="text-center mb-10 py-4 rounded" style="font-size: 28px;">
            <strong>Perbaharui Data Mahasiswa</strong>
        </h3>

        <br/>

        <div class="row justify-content-center">
            <div class='col-sm-12'>
                <form action="" method="post">
                    <input type="hidden" name="id" value="<?php echo $mhs["id"]; ?>">
                    <table class='table table-bordered w-100' style="font-size: 18px;">
                        <tr style="height: 65px;">
                            <td class="text-center align-middle" style="width: 30%;"><strong>Alternatif</strong></td>
                            <td><input name="alternatif" type='text' class='form-control' style="font-size: 18px; height: 50px;" value="<?php echo $mhs["alternatif"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>Nama</strong></td>
                            <td><input type="text" name="nama" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $mhs["nama"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>NIM</strong></td>
                            <td><input type="text" name="nim" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $mhs["nim"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>E-mail</strong></td>
                            <td><input type="email" name="email" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $mhs["email"]; ?>" required></td>
                        </tr>
                        <tr>
                            <td class="text-center" colspan="2">
                                <div class="d-flex justify-content-center gap-2">
                                    <button class="btn btn-primary" type="submit" name="submit" style="font-size: 18px; padding: 10px 20px;">
                                        <i class="fas fa-check"></i> Ubah Data
                                    </button>
                                    <button class="btn btn-danger" type="submit" name="hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?');" style="font-size: 18px; padding: 10px 20px;">
                                        <i class="fas fa-trash"></i> Hapus Data
                                    </button>
                                </div>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>
    </main>
</div>

<script type="text/javascript">
    $(function () {
        $('#datetimepicker').datetimepicker({ format: 'DD MMMM YYYY HH:mm' });
        $('#datepicker').datetimepicker({ format: 'DD MMMM YYYY' });
        $('#date').datetimepicker({ format: 'DD MMMM YYYY' });
        $('#timepicker').datetimepicker({ format: 'HH:mm' });
    });
</script>
